<?php
require_once 'header.php';

if(!$usersObject->ID()) {
	header("Location: /");
	exit;
}

$the_domain = 'http://'.$_SERVER['SERVER_NAME'];

$month = date("M");
$year= date("Y");

if(isset($_GET['m'])) $month = (string) $db->escape(trim(strip_tags($_GET['m'])));
if(strlen($month) != 3) die("Incorrect month");

if(isset($_GET['y'])) $year = (int) $db->escape(trim(strip_tags($_GET['year'])));
if(strlen($year) != 4) die("Incorrect year");

?>

<div class="container ctwhite" style="margin-top:20px;">

	<h3 class="headline-inline"><?=translate('create_cmp')?> (<a href="/advertiser.php"><?=translate('back_to_list') ?></a>)</h3>
	
	
	<?php
	if(isset($_POST['sb'])) {
		$title = (string) $db->escape(trim(strip_tags($_POST['title'])));
		$site = (string) $db->escape(trim(strip_tags($_POST['site'])));
		
		if(empty($title) OR !stristr($site, 'http')) {
			print '<div class="alert alert-warning">Please enter site title and a domain name starting with http:// or https://</div>';
		}else{
			$total_price = 0;
			$ids = array();
			
			foreach($_POST as $k=>$v) {
				if(stristr($k, 'country_')) {
					if(abs(intval($v)) > 0) {
						
						$visitors = abs(intval($v)).'000';
						$the_country = $db->escape(str_replace("country_", "", $k));
						
						$db->query("INSERT INTO advertisers (title, site, country, ordered, status, user) VALUES 
									('$title', '$site', '$the_country', '$visitors','Pending', '".$db->escape($usersObject->ID())."')");
						$ids[] = $db->insert_id;
						$aff_cID = $db->insert_id;
						
						//update total price
						$price = $db->get_row("SELECT price_k FROM pricing WHERE country = '$the_country' LIMIT 1");
						$total_price += number_format($price->price_k*abs(intval($v)), 0);
						
						
						//add referral if any
						if(isset($_COOKIE['affID'])) {
							$affID = (int) $db->escape(abs(intval($_COOKIE['affID'])));
							
							
							if($affID > 0 AND $affID != $usersObject->ID()) {
								$earned_amount = (($price->price_k*abs(intval($v)))*AFFILIATE_PERCENTAGE)/100;
								$earned_amount = number_format($earned_amount, 5);
								$db->query("INSERT INTO affiliates VALUES (NULL, '".date("M")."', '".date("Y")."', 
																			'".time()."','".$affID."', '".$earned_amount."', 
																			'".$aff_cID."')");
							}
						}
						
						 
					}
				}
			}
			
			if($total_price > 0) {
				
				if($total_price < MIN_ORDER) {
					print '<div class="alert alert-warning">'.translate('order_min_amount').' <strong>$'.MIN_ORDER.'</strong></div>';
				}else{
					$_SESSION['price'] = $total_price;
					$_SESSION['ids'] = implode(",", $ids);
					header("Location: /payments.php");
				}
				
			}else{
				print '<div class="alert alert-warning">'.translate('order_min_k').' <strong>1K</strong></div>';
			}
		}
		
	}
	?>
	
	<form method="POST" action="" class="form-horizontal">
		<label><?=translate('cmp_title') ?>:</label>
		<input type="text" name="title" placeholder="My Campaign" class="input-xxlarge"/>
		<br/>
		<br/>
		
		<label><?=translate('site_url') ?>:</label>
		<input type="text" name="site" placeholder="http://destinationsite.tld" class="input-xxlarge"/>
		
	<br/><br/>
	
	<table class="table table-bordered table-hover">
		<thead>
			<th><?=translate('country') ?></th>
			<th><?=translate('country_code') ?></th>
			<th><?=translate('price_per_k') ?></th>
			<th><?=translate('order') ?></th>
		</thead>
		<tbody>
			<?php
			$pricing = $db->get_results("SELECT pricing.pID, pricing.country, pricing.price_k, countries.country as cname  
			                           FROM pricing, countries WHERE pricing.country = countries.ccode ORDER BY price_k DESC");
			foreach($pricing as $p) {
				print '<tr>';
				print '<td>'.$p->cname.'</td>';
				print '<td>'.$p->country.'</td>';
				print '<td>$'.number_format($p->price_k, 0).'</td>';
				print '<td><input type="number" name="country_'.$p->country.'" value="0" class="input-mini"/> <span class="label label-warning" style="font-size:20px;">k</span></td>';
				print '</tr>';
			}						
			?>
		</tbody>
	</table>
	
		<input type="submit" name="sb" value="<?=translate('place_order');?>" class="btn btn-warning btn-large" style="margin-left:300px;"/>
		
		</form>
</div>

<?php
require_once 'footer.php';
?>